// main project include
#include <App.h>

// this form
#include <EditView.h>


//- public data

//- private data
static DWord iDBrec;		// index to record in database
static VoidHand hDBrec;		// handle to record in database
static UInt dbRecSize;		// size of record in database
static Boolean dirty;		// is record dirty as a result of our editing?

static VoidHand hMemRec;	// handle to temp record in memory
static UInt memRecSize;		// size of record in memory
static UInt memRecMaxSize;	// size of memory allocated for record

static UInt nEvents;		// how many midi events?
static UInt nCurEvent;		// currently selected midi event

static VoidHand hMidiOffset;	// index into midi data -- array "nEvents" long


#define TEXT_SIZE 81

typedef struct ExpandedRec {
	char text[TEXT_SIZE];
} ExpandedRec;

typedef struct StorageRec {
	char text[TEXT_SIZE];
} StorageRec;

static VoidHand readAndExpand(VoidHand hDbRec)
{
	VoidHand hMemRec;
	ExpandedRec *pMemRec;
	
	memRecMaxSize = sizeof(ExpandedRec);
	hMemRec = MemHandleNew(memRecMaxSize);

	pMemRec = MemHandleLock(hMemRec);
	
//	if (!pMemRec || !pDbRec || !pMidiOffset)
//		Alert!!!


	StrCopy(pMemRec->text, "Data for Record #@");
	pMemRec->text[17] = '0' + iDBrec;


	//- clean up: these stick around
	MemHandleUnlock(hMemRec);
	
	return hMemRec;
}

static void compressAndSave(VoidHand hDbRec, VoidHand hMemRec)
{
	//- shortcut if storage structure is in-memory structure:
	//	detach hDbRec from db and attach hMemRec
	//	note: will change record unique id, which would probably
	//	be a Bad Thing(tm).  Don't do it, but leave the note here
	//	so I can be reminded why not to do it that way.
	
	//- compress in-memory record (hMemRec)
	
	//- check size of dbRec against (compressed) memRec & resize dbRec if necessary
	
	// copy in-memory to db (hMemRec to hDBrec)
	
	//- clean up: these stick around
	
	// note: hMemRec not released until formCleanup()
}


static void DataListDrawFunc(UInt itemNum, RectanglePtr bounds, CharPtr *data)
{
	ExpandedRec	 *pMemRec = MemHandleLock(hMemRec);
	Char *sz;

	
	sz = pMemRec->text;
	
	//- replace this w/ routine that uses tabs to align columns
	WinDrawChars(sz, StrLen(sz), bounds->topLeft.x, bounds->topLeft.y);

	MemHandleUnlock(hMemRec);
}

//- generalize this function to take listID so it would scroll
//	list object w/ matching ID on current form
//	would have to have error handling if ID was not on current form
static void ScrollDataList(enum directions dir, short nItems)
{
	FormPtr     frm = FrmGetActiveForm();
	Word		listIndex  = FrmGetObjectIndex(frm, EditViewDataList);
	ListPtr     pList = FrmGetObjectPtr(frm, listIndex);

	LstScrollList (pList, dir, nItems) ;
}


/*
** DESCRIPTION:     Initializes the data & objects for this form
**
** RETURNS:			Nothing.
*/

static void InitForm(FormPtr frm)
{
	// ...and anything else you need...
	Word		listIndex  = FrmGetObjectIndex(frm, EditViewDataList);
	ListPtr     pList = FrmGetObjectPtr(frm, listIndex);
	
	
	//- initialize menu
	FrmSetMenu(frm, EditViewMenuBar);
	
	//- initialize the list object
	LstSetListChoices(pList, NULL, 1);
	LstSetDrawFunction(pList, DataListDrawFunc);
	LstSetSelection(pList, nCurEvent);
	
	CurrentView = EditViewForm;
}

void EditRecordByIndex(DWord idx)
{
	iDBrec = idx;
	hDBrec = NULL;
	dirty = false;

	hMemRec = readAndExpand(hDBrec);
	
	FrmGotoForm(EditViewForm);
}

static void CleanupForm(void)
{
//	DmReleaseRecord(db, iDBrec, dirty);
	MemHandleFree(hMemRec);
}

static Boolean MenuHandler(Word menuID)
{
	Boolean handled = true;	// set to false in default case of switch
   
	if (!HandleCommonMenuItems(menuID)) {
		switch (menuID) {
//			case MenuOptionID:
//				handled = firstMenuOptionHandler();
//				break;
//...
         
			default:
				handled = false;
				break;
		}
   }
   
   return handled;
}

static Boolean ButtonHandler(Word ctlID)
{
	Boolean handled = true;
	
	switch (ctlID) {
//		case FirstButtonID:
//			handled = firstButtonHandler();
//			break;
//...
		case EditViewDoneButton:	// support ok/cancel?
			// compress hMemRec in-memory, then write to hDBrec
			compressAndSave(hDBrec, hMemRec);
			FrmGotoForm(ListViewForm);
			break;
					
				
		default:
			handled = false;
			break;
	}
	
	return handled;
}
/*
** DESCRIPTION:	    Handles processing of events for the form.
**
** PARAMETERS:		event	- the most recent event.
**
** RETURNS:			True if the event is handled, false otherwise.
*/

Boolean EditViewEventHandler(EventPtr event)
{
	Boolean			handled = true;
	FormPtr 		frm;

	switch (event->eType) {
  		case frmOpenEvent:	// The form was told to open.
  			// Initialize the main form.
			frm = FrmGetActiveForm ();
			InitForm(frm);
			FrmDrawForm (frm);
			break;
		
		case frmUpdateEvent:
			frm = FrmGetActiveForm ();
			// additional drawing code here
			FrmDrawForm (frm);
			break;
			
		case frmSaveEvent:
			// save runtime data into "unsaved prefs" db
			// save form ID as current form IFF this is the current form
			// save nEvents & nCurEvent
			// ... or will we end up releasing in-memory track when frmCloseEvent comes 'round?
			compressAndSave(hDBrec, hMemRec);
			break;

			
		case frmCloseEvent:
			// guaranteed to get frmSaveEvent before frmCloseEvent?
			CleanupForm();
			break;
			
		case menuEvent:
			handled = MenuHandler(event->data.menu.itemID);
			break;
	
	   	case ctlSelectEvent:  // A control button was pressed and released.
	   		handled = ButtonHandler(event->data.ctlEnter.controlID);
			break; // end: ctlSelectEvent
			

		default:
			handled = false;
			break;
	}

	return(handled);
}



