// main project include
#include <App.h>

//- other system includes
#include <SoundMgr.h>

// this form
#include <ListView.h>
#include <EditView.h>

//- private data
static UInt nRecs;
static UInt nCurSel = 0;


static void doEditCurrentRecord(void)
{
	// get handle to currently selected sound
	// & put in global area for EditView to play with
#if 0
	FormPtr frm = FrmGetActiveForm();
	Word		listIndex = FrmGetObjectIndex(frm, ListRecordsList);
	ListPtr     list = FrmGetObjectPtr(frm, listIndex);
	
	Word nCurSel = LstGetSelection(list);
	
	if (nCurSel == noListSelection) {
		FrmAlert(NoSelectionAlert);
	} else 
#endif
	{
		EditRecordByIndex(nCurSel);		// does FrmGotoForm() !
	}
}

static void RecordListDrawFunc(UInt itemNum, RectanglePtr bounds, CharPtr *data)
{
	char s[41];
	
	StrCopy(s, "Record #@");
	s[8] = '0' + itemNum;
	
		
	WinDrawChars(s, StrLen(s), bounds->topLeft.x, bounds->topLeft.y);
}

static void ScrollRecordList(enum directions dir, short nItems)
{
	FormPtr     frm = FrmGetActiveForm();
	Word		listIndex  = FrmGetObjectIndex(frm, ListViewRecordsList);
	ListPtr     pList = FrmGetObjectPtr(frm, listIndex);

	LstScrollList (pList, dir, nItems) ;
}

/*
** DESCRIPTION:     Initializes the data & objects for this form
**
** RETURNS:			Nothing.
*/

static void FormInit(FormPtr frm)
{

	Word		listIndex  = FrmGetObjectIndex(frm, ListViewRecordsList);
	ListPtr     pList = FrmGetObjectPtr(frm, listIndex);
	
	
	//- initialize menu
	FrmSetMenu(frm, ListViewMenuBar);
	
	//- initialize list object
	nRecs = 7;
	
	LstSetListChoices(pList, NULL, nRecs);
	LstSetDrawFunction(pList, RecordListDrawFunc);
	LstSetSelection(pList, nCurSel);
	
	CurrentView = ListViewForm;
}

static Boolean  MenuHandler(Word menuID)
{
	Boolean handled = true;	// set to false in default case of switch
   
	if (!HandleCommonMenuItems(menuID)) {
		switch (menuID) {
//			case MenuOptionID:
//				handled = firstMenuOptionHandler();
//				break;
//...

			case RecordNew:
				break;
				
			case RecordDelete:
				break;
				
			case RecordEdit:
				doEditCurrentRecord();
				break;
         
			default:
				handled = false;
    	  		break;
		}
	}
   
   return handled;
}

static Boolean KeyHandler(Word ch, Word modifiers)
{
	Boolean handled = true;	// set to false in default case of switch
   
	switch (ch) {
//		case MenuOptionID:
//			handled = firstMenuOptionHandler();
//			break;
//...

		case pageUpChr:
		 	ScrollRecordList(up, 1);
			break;
			
		case pageDownChr:
		 	ScrollRecordList(down, 1);
			break;
         
		default:
			handled = false;
     		break;
	}
   
   return handled;}

static Boolean ButtonHandler(Word ctlID)
{
	Boolean handled = true;	// set to false in default case of switch
	
	switch (ctlID) {
//	case FirstButtonID:
//		handled = firstButtonHandler();
//		break;
//...
#if 0
	case ListViewDetailsButton:
		// get currently selected item from list
		// run details form (modal)
		// ... if current item deleted, repaint
		FrmGotoForm(MidiDetailsForm);
		break;
#endif

	case ListViewNewButton:
		callMenu(RecordNew);
		break;
		
//	case ListViewDeleteButton:
//		callMenu(RecordDelete);
//		break;
			
	case ListViewEditButton:
		callMenu(RecordEdit);
		break;
					

#if 0
	case ListViewDupButton:
		// make copy of record w/ new name
		break;
#endif

	default:
		handled = false;
		break;
	}

	return handled;
}

/*
** DESCRIPTION:	    Handles processing of events for the form.
**
** PARAMETERS:		event	- the most recent event.
**
** RETURNS:			True if the event is handled, false otherwise.
*/

Boolean ListViewEventHandler(EventPtr event)
{
	Boolean			handled = true;
	FormPtr 		frm;

	switch (event->eType) {
  		case frmOpenEvent:	// The form was told to open, initialize it
			frm = FrmGetActiveForm ();
			
			// set things up (list draw callback, etc.)
			FormInit(frm);
			
			// draw
			FrmDrawForm (frm);
			break;
		
		case frmUpdateEvent:
			frm = FrmGetActiveForm ();
			// additional drawing code here
			FrmDrawForm (frm);
			break;
			
		case frmSaveEvent:
			// save runtime data into "unsaved prefs" db
			// save form ID as current form IFF this is the current form!
			// save nCurSel as current record
			break;
			
		case frmCloseEvent:
			// save anything that needs saving
			// and either delete form memory -OR-
			// just say it's not been handled and
			// let the default handler take care of
			// that.
			break;
			
		case menuEvent:
			handled = MenuHandler(event->data.menu.itemID);
			break;
			
		case keyDownEvent:
			handled = KeyHandler(event->data.keyDown.chr, event->data.keyDown.modifiers);
			break;
			
	   	case ctlSelectEvent:  // A control button was pressed and released.
	   		handled = ButtonHandler(event->data.ctlEnter.controlID);
			break; // end: ctlSelectEvent
			
		case lstSelectEvent:	// listID, ListType *pList, selection
			nCurSel = event->data.lstSelect.selection;
			// have to save it in UnsavedPrefs!
//			handled = false;	// let them take care of it normally
			break;
			
		default:
			handled = false;
			break;
	}

	return(handled);
}



